#!/bin/sh
CUT=/mnt/card/cut

vafname="va1809.o"
version="4.04"
kernelVer="2.00"

echo "//////////////////////////////////////////////"
echo "SetUp VA1809"
echo "//////////////////////////////////////////////"

function writeFPGA()
{
	#
	#--- Ǎݐpɂ ---
	#
	mount -o remount,ro /mnt/flash3

	#
	#--- FPGAXV ---
	#
	if [ -s /mnt/card/fpgawriter.o ]
	then
		echo " Update FPGA"
		/mnt/card/dispout.o 1 " FPGA WRITING .....     "
		/mnt/card/fpgawriter.o
	#	echo "Return Code : " $?
		case $? in
			255)/mnt/card/dispout.o 1 " Warnig FPGA WRITE ERR!!"
				/astro/testvram buzzer 4
				exit
				;;
			254)/mnt/card/dispout.o 1 " Warnig FPGA NMAP ERR!!"
				/astro/testvram buzzer 4
				exit
				;;
			253)/mnt/card/dispout.o 1 " Missing Device file !!"
				/astro/testvram buzzer 4
				exit
				;;
			252)/mnt/card/dispout.o 1 " Missing h8main.mot !!"
				/astro/testvram buzzer 4
				exit
				;;
			251)/mnt/card/dispout.o 1 " Missing fpgawriter.o !!"
				/astro/testvram buzzer 4
				exit
				;;
		esac
	fi
}


#
#--- @킩ׁAĂI ---
#
if [ ! -s /astro/va.o ]
then
	echo "Not VA-1809 !!"
	exit
fi


#
#--- vZX̏I҂ ---
#
echo "Wait Process End ..."
PID=`ps ax | grep va.o | grep -v grep | ${CUT} -f 4 -d " "`
echo "pid :"$PID
while [ "$PID" != "" ]
do
	echo " Wait for va.o.(1 seconds) ....."
	kill -9 $PID
	sleep 1
	PID=`ps ax | grep va.o | grep -v grep | ${CUT} -f 4 -d " "`
	echo "pid :"$PID
done
sleep 2

/mnt/card/dispout_va.o 0 $version

sleep 1



#
#--- PID File̍폜 ---
#
echo "Delete Process File ..."
if [ -s /var/run/va.pid ]
then
	rm /var/run/va.pid
fi
#if [ -s /var/run/udpproc.pid ]
#then
#	rm /var/run/udpproc.pid
#fi

#
#--- ݉\ɂ ---
#
echo " Remount r/w mode ....."
mount -o remount,rw /mnt/flash3



#--------------------------------------
#2007.3.30ǉn-kogure
#--- IPL`FbN
#
if [ -s /mnt/card/sh-stub.bin ]
then
	if [ -s /mnt/card/newipl.dd ]
	then
		diff /dev/mtd1 /mnt/card/newipl.dd
		if [ "$?" = "1" ]
		then
#--- IPLp[eBV폜 ---
#
			echo " eraseall /dev/mtd1"
			eraseall /dev/mtd1

#
#--- IPL ---
#
			echo " cp -f /mnt/card/sh-stub.bin /dev/mtd1"
			cp -f /mnt/card/sh-stub.bin /dev/mtd1
		else
			echo " ipl same data"
		fi
	fi
fi
#--------------------------------------


#
#--- ŏɃt@C폜 ---
#
echo "Delete va.o ..."
cd /astro
for fname in va*.o
do
	rm $fname
	echo " remove "$fname
done
cd

#
#--- mɃt@C폜 ---
#
sync
mount -o remount,ro /mnt/flash3
sync
mount -o remount,rw /mnt/flash3
sync

/mnt/card/dispout_va.o 1 $version



#
#--- va1809.oXV ---
#
if [ -s /mnt/card/$vafname ]
then
	cp -f /mnt/card/$vafname /astro
	echo " Update "$vafname" ....."
fi
/mnt/card/dispout_va.o 2 $version

#
#--- hCot@CXV ---
#
if [ -s /mnt/card/va1809_drv.o ]
then
	echo " Update "va1809_drv.o" ..."
	cp -f /mnt/card/va1809_drv.o /astro
fi

if [ -s /mnt/card/va1809_lcdif.o ]
then
	echo " Update "va1809_lcdif.o" ..."
	cp -f /mnt/card/va1809_lcdif.o /astro
fi

if [ -s /mnt/card/va1809_frsw.o ]
then
	echo " Update "va1809_frsw.o" ..."
	cp -f /mnt/card/va1809_frsw.o /astro
fi


#if [ -s /mnt/card/udpproc ]
#then
#	echo " Update "udpproc" ..."
#    cp -f /mnt/card/udpproc /astro
#fi
#
#--- J[lXV(VersionقȂꍇ̂) ---
#
/mnt/card/dispout_va.o 3 $version

#݂̃J[lo[Wǂݍ
VER=`cat /proc/version | grep VA-1809 | /mnt/card/cut -f 2 -d " "`
if [ "$kernelVer" != "$VER" ]
then
	if [ -s /mnt/card/zImage ]
	then
		echo " Update zImage"

		eraseall /dev/mtd2
		cp -f /mnt/card/zImage /dev/mtd2
		echo "OLD kenel ver:"$VER
		echo "NEW kenel ver:"$kernelVer
	fi
else
	echo "Kenel is same!! can't update zImage "
fi

if [ -s /mnt/card/motd ]
then
	echo " Update "motd" ..."
	cp -f /mnt/card/motd /etc
fi

if [ -s /mnt/card/rc.local ]
then
	echo " Update "rc.local" ..."
	cp -f /mnt/card/rc.local /etc/rc.d
fi

#
#--- N쐬 ---
#
ln -s /astro/$vafname /astro/va.o
#
#---CZX ---
#
	cp -f /mnt/card/license.dat /astro
	echo " Update "license.dat" ....."
#
#--- FPGAXV ---
#
/mnt/card/dispout_va.o 4 $version

writeFPGA

sync
sync
sync

sleep 2

echo "//////////////////////////////////////////////"
echo "SetUp Complete."
sleep 2
echo "Please power off."
echo "//////////////////////////////////////////////"
/mnt/card/dispout_va.o 5 $version

exit 0

